<?php

namespace App\Console\Commands;

use App\Services\SitemapService;
use Illuminate\Console\Command;

class GenerateSitemap extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'seo:generate-sitemap';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generate XML sitemap and robots.txt for SEO';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Generating sitemap...');

        $sitemapService = new SitemapService();
        
        // Add static pages
        $sitemapService->addStaticPages();
        
        // Add dynamic pages
        $sitemapService->addDynamicPages();
        
        // Generate and save sitemap
        $sitemapPath = $sitemapService->save();
        $this->info("Sitemap generated: {$sitemapPath}");
        
        // Generate and save robots.txt
        $robotsPath = $sitemapService->saveRobotsTxt();
        $this->info("Robots.txt generated: {$robotsPath}");
        
        $this->info('SEO files generated successfully!');
        
        return Command::SUCCESS;
    }
} 