<?php

namespace App\Filament\Resources\NewsResource\Pages;

use App\Filament\Resources\NewsResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;

class EditNews extends EditRecord
{
    protected static string $resource = NewsResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }


    protected function mutateFormDataBeforeFill(array $data): array
    {
        if (isset($data['attachments']) && is_array($data['attachments'])) {
            $data['attachments'] = collect($data['attachments'])->map(function ($item) {
                $item['original_url'] = $item['url'] ?? null;
                return $item;
            })->toArray();
        }

        return $data;
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        if (isset($data['attachments']) && is_array($data['attachments'])) {
            $data['attachments'] = collect($data['attachments'])->map(function ($item) {
                if (empty($item['url']) && !empty($item['original_url'])) {
                    $item['url'] = $item['original_url'];
                }
                unset($item['original_url']);
                return $item;
            })->toArray();
        }

        return $data;
    }
}
