<?php

namespace App\Http\Controllers\Api;

use App\Models\News;
use Illuminate\Http\Request;
use App\Services\NewsService;
use App\Http\Controllers\Controller;

class NewsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $jsonFilePath = storage_path('app/news.json');
        if (file_exists($jsonFilePath)) {
            $jsonData = file_get_contents($jsonFilePath);
            $news = json_decode($jsonData, true);

            return response()->json(['news' => $news], 200);
        } else {
            return response()->json(['error' => 'News data file not found.'], 404);
        }
    }


    public function FilterNews(Request $request, NewsService $newsService)
    {
        $searchQuery = $request->input('search', '');
        $categoryQuery = $request->input('category', '');
        $page = $request->input('page', 1);
        $filteredNews = $newsService->filterNews($searchQuery, $categoryQuery, $page);
        return response()->json($filteredNews);
    }

}
