<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Hash;

class PageSetting extends Model
{
    use HasFactory;

    protected $fillable = [
        'page_name',
        'page_url',
        'is_protected',
        'password',
    ];

    protected $casts = [
        'is_protected' => 'boolean',
    ];

    /**
     * Set the password attribute (hash it automatically)
     */
    public function setPasswordAttribute($value)
    {
        if (!empty($value)) {
            $this->attributes['password'] = Hash::make($value);
        } else {
            // If empty value and password is not already set, allow null
            if (!isset($this->attributes['password'])) {
                $this->attributes['password'] = null;
            }
        }
    }

    /**
     * Check if password matches
     */
    public function checkPassword($password)
    {
        $storedPassword = $this->attributes['password'] ?? null;
        if (!$storedPassword) {
            return false;
        }
        return Hash::check($password, $storedPassword);
    }
}
