<?php

namespace App\Providers;

use App\Services\SeoService;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->singleton(SeoService::class, function ($app) {
            return new SeoService();
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Register SEO Blade directive
        Blade::directive('seo', function ($expression) {
            return "<?php echo app('App\\Services\\SeoService')->render(); ?>";
        });

        // Register SEO JSON-LD directive
        Blade::directive('seoJsonLd', function ($expression) {
            return "<?php echo app('App\\Services\\SeoService')->renderJsonLd($expression); ?>";
        });

        // Register PDF viewer URL helper
        Blade::directive('pdfViewerUrl', function ($expression) {
            return "<?php echo \\App\\Http\\Controllers\\HomeController::generatePdfViewerUrl($expression); ?>";
        });
    }
}
