<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        // Add rate limiting for form submissions
        $middleware->alias([
            'throttle.forms' => \App\Http\Middleware\ThrottleFormSubmissions::class,
            'page.protection' => \App\Http\Middleware\CheckPageProtection::class,
        ]);
        
        // Add page protection to web middleware group
        $middleware->web(append: [
            \App\Http\Middleware\CheckPageProtection::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
