<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('news', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('body');
            $table->string('image');
            $table->date('date');
            $table->string('category')->nullable();
            $table->string('tags')->nullable();
            $table->json('attachments')->nullable();
            $table->timestamps();
            $table->softDeletes();

            // Add indexes for frequently queried columns
            $table->index('category');
            $table->index('created_at');
            // Specify key length for TEXT column (MySQL limitation)
            $table->index(['title', DB::raw('body(255)')], 'news_search_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('news');
    }
}; 