<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('spam_attempts', function (Blueprint $table) {
            $table->id();
            $table->string('ip_address');
            $table->string('user_agent')->nullable();
            $table->string('form_type'); // 'contact' or 'career'
            $table->string('spam_type'); // 'honeypot', 'timing', 'keywords', 'patterns', 'ip_reputation'
            $table->text('details')->nullable(); // Additional details about the spam attempt
            $table->boolean('blocked')->default(false);
            $table->timestamp('blocked_at')->nullable();
            $table->timestamps();
            
            $table->index(['ip_address', 'created_at']);
            $table->index(['form_type', 'created_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('spam_attempts');
    }
};
