<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('page_settings', function (Blueprint $table) {
            $table->id();
            $table->string('page_name'); // Display name e.g., 'PBL Integrated Report', 'PICL Annual Report'
            $table->string('page_url')->unique(); // Full URL path e.g., '/pbl-integrated-report/2025' (unique identifier)
            $table->boolean('is_protected')->default(false); // Whether password protection is enabled
            $table->string('password')->nullable(); // Hashed password
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('page_settings');
    }
};
