<?php

namespace Database\Seeders;

use App\Models\Brand;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class BrandSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $brands = [
            ['logo' => '2024---Kenyan-Originals.png', 'year' => '2024', 'name' => 'Kenyan Originals', 'description' => 'Investment in Kenya'],
            ['logo' => '2023---Salitos.png', 'year' => '2023', 'name' => 'Salitos', 'description' => 'Salitos'],
            ['logo' => '2022---Panaché.png', 'year' => '2022', 'name' => 'Panaché', 'description' => 'Launch of Phoenix Panaché'],
            ['logo' => '2022---Manawa.png', 'year' => '2022', 'name' => 'Manawa', 'description' => 'Launch of Manawa'],
            //['logo' => '2020---Phoenix-Keg-5L.png', 'year' => '2020', 'name' => 'Phoenix-Keg-5L', 'description' => 'Launch of Phoenix Keg 5lt'],
            ['logo' => '2020---Cidona.png', 'year' => '2020', 'name' => 'Cidona', 'description' => 'Relaunching of Cidona'],
            //['logo' => '2019---Crystal-Jar-11.3.png', 'year' => '2019', 'name' => 'Crystal-Jar', 'description' => 'Launch of Crystal Jar 11.3 Lt'],
            //['logo' => '2018---Phoenix-Can-500ml.png', 'year' => '2018', 'name' => 'Phoenix-Can-500ml', 'description' => 'Launch of Phoenix Can 500 ml'],
            ['logo' => '2017---FuzeTea.png', 'year' => '2017', 'name' => 'FuzeTea', 'description' => 'Launch of Fuze Tea'],
            //['logo' => '2017---Crystal-Eco-Twist.png', 'year' => '2017', 'name' => 'Crystal-Eco-Twist', 'description' => 'Launch of the new Crystal Eco-Twist Bottle'],
            //['logo' => '2017---5Alive.png', 'year' => '2017', 'name' => '5Alive', 'description' => 'Launch of 5 Alive juice'],
            //['logo' => '2016---New-Production-Unit.png', 'year' => '2016', 'name' => 'New-Production-Unit', 'description' => 'Commissioning of new production unit in Nouvelle France'],
            ['logo' => '2016---Gister.png', 'year' => '2016', 'name' => 'Gister', 'description' => 'Launch of Gister premium beer'],
            ['logo' => '2016---Edena.png', 'year' => '2016', 'name' => 'Edena', 'description' => ' Acquisition of Edena SA (incorporated in Réunion Island)'],
            ['logo' => '2015---Orangina.png', 'year' => '2015', 'name' => 'Orangina', 'description' => 'Bottling agreement with Schweppes International Limited for Orangina'],
            ['logo' => '2015---GR8.png', 'year' => '2015', 'name' => 'GR8 Cape Wine', 'description' => 'Launch of GR8 Cape wine'],
            //['logo' => '2014---Installation-Wine-Bottle-2.png', 'year' => '2014', 'name' => 'Installation-Wine-Bottle', 'description' => 'Installation of wine bottling line'],
            //['logo' => '2014---Installation-Wine-Bottle.png', 'year' => '2014', 'name' => 'Installation-Wine-Bottle', 'description' => 'Installation of wine bottling line'],
            ['logo' => '2014---Eski.png', 'year' => '2014', 'name' => 'Eski', 'description' => 'Acquisition of Eski, the famous Mauritian brand'],
            ['logo' => '2010---Phoenix-Cider.png', 'year' => '2010', 'name' => 'Phoenix-Cider', 'description' => 'Launch of Phoenix Cider'],
            //['logo' => '2009---Phoenix-Réunion.png', 'year' => '2009', 'name' => 'Phoenix-Réunion', 'description' => 'Phoenix Réunion SARL (incorporated in Réunion Island set up)'],
            ['logo' => '2008---Phoenix-Fresh.png', 'year' => '2008', 'name' => 'Phoenix-Fresh', 'description' => 'Launch of Phoenix Fresh'],
            //['logo' => '2008---Amalgamation-PBL-&-PCM.png', 'year' => '2008', 'name' => 'Amalgamation-PBL-&-PCM', 'description' => 'Amalgamation of PBL and PCM'],
            ['logo' => '2005---Phoenix-Special-Brew.png', 'year' => '2005', 'name' => 'Phoenix-Special-Brew', 'description' => 'Launch of Phoenix Special Brew'],
            //['logo' => '2003---New-Distribution.png', 'year' => '2003', 'name' => 'New-Distribution', 'description' => 'Launch of Crystal Jar 11.3 Lt'],
            //['logo' => '2003---MBL-to-PBL.png', 'year' => '2003', 'name' => 'MBL-to-PBL', 'description' => 'Incorporation of Mauritius Breweries limited (MBL)'],

            ['logo' => '1988---Malta-Guiness.png', 'year' => '1988', 'name' => 'Malta-Guiness', 'description' => 'Launch of Malta Guinness'],
            ['logo' => '1988---Guinness.png', 'year' => '1988', 'name' => 'Guinness', 'description' => 'Launch of Guinness stout'],
            ['logo' => '1986---Diet-Coke.png', 'year' => '1986', 'name' => 'Diet-Coke', 'description' => 'Launch of Diet Coke'],
            ['logo' => '1979---Pearona.png', 'year' => '1979', 'name' => 'Pearona', 'description' => 'Launch of Pearona'],
            ['logo' => '1976---Crystal.png', 'year' => '1976', 'name' => 'Crystal', 'description' => 'Launch of Crystal table water'],

            ['logo' => '1965---Sprite.png', 'year' => '1965', 'name' => 'Sprite', 'description' => 'Launch of Sprite'],
            ['logo' => '1964---Stella.png', 'year' => '1964', 'name' => 'Stella', 'description' => 'Stella Pils released on the market to extend the range of beers'],
            ['logo' => '1963---Phoenix-Beer.png', 'year' => '1963', 'name' => 'Phoenix-Beer', 'description' => 'Birth of Phoenix Beer'],
            ['logo' => '1963----Inauguration-of-Brewery.png', 'year' => '1963', 'name' => 'Inauguration-of-Brewery', 'description' => 'Inauguration of the Brewery'],

            ['logo' => '1960---MBL.png', 'year' => '1960', 'name' => 'MBL', 'description' => 'Incorporation of Mauritius Breweries limited (MBL)'],
            ['logo' => '1958---Coca-Cola.png', 'year' => '1958', 'name' => 'Coca-Cola', 'description' => 'Bottling agreement with The Coca-Cola Company'],
            ['logo' => '1956---Fanta.png', 'year' => '1956', 'name' => 'Fanta', 'description' => ' Launch of Fanta'],
            ['logo' => '1931---PCM.png', 'year' => '1931', 'name' => 'PCM', 'description' => 'Launch of PCM']
        ];

        Brand::upsert($brands, ['logo'], ['year', 'name','description']);
    }
}
