@extends('layouts.app')
@section('content')
    <div class="page-blue">
        <div class="about-banner contact-banner bg-image" style="background-image: url({{ asset('images/sustainability/csr_cover.png') }});">
        </div>
        <div class="page-title-container">
            <h4>Corporate Social Responsibility</h4>
            <span class="text-primary">Caring for Others</span>
        </div>
    </div>

    <div class="container landing-section">
        <div class="row">
            <div class="col-12 col-lg-8 offset-lg-2" data-aos="fade-down" data-aos-duration="1000" data-aos-easing="linear">
                <div class="center">
                    <h3>Giving Back to the Society</h3>
                    <p>Aligned with Phoenix Beverages Group's CSR policy, the company actively supports and contributes to societal well-being.
                        To streamline its philanthropic initiatives, Phoenix Beverages Group has entrusted the management of its funds to two dedicated entities:
                        the Phoenix Foundation and the Joseph Lagesse Foundation.</p>
                </div>
            </div>
        </div>

        <div class="row mt-100 mb-6">
            <div class="col-lg-6 col-md-12 smaller-text px-3" data-aos="fade-down" data-aos-duration="1000" data-aos-easing="linear">
                <div>
                    <p>Phoenix Foundation has helped various NGO projects and was granted a funding of MUR 4M for the past
                        year. It has allocated its donations to the following five main areas:</p>
                    <ul class="ml-30">
                        <li>Protection, health and social integration of vulnerable groups</li>
                        <li>Poverty alleviation, community development and capacity building</li>
                        <li>Education, welfare and development of vulnerable children</li>
                        <li>Environment and sustainability</li>
                        <li>Sports and culture</li>
                    </ul>

                    <p>Phoenix Beverages Group, through its foundations, has assisted and accompanied several NGOs in their
                        projects.</p>

                    <div>The main beneficiaries were:</div>
                    <ul class="ml-30">
                        <li>FoodWise</li>
                        <li>Caritas Ile Maurice</li>
                        <li>Vent d'un Rêve</li>
                        <li>ANFEN</li>
                        <li>Link to Life</li>
                        <li>SOS Children's Village Mauritius</li>
                        <li>Dis-Moi (Droits Humain Océan Indien)</li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-6 col-md-12 px-3" data-aos="fade-down" data-aos-duration="1000" data-aos-easing="linear">

                <div class="hero-content">
                    <div class="slider">
                        <div class="dashSlides">
                            <div class="csrSlide animate__animated animate__fadeIn animate__slower 3s">
                                <div class="slide-content">
                                        <div class="image-container animate__animated animate__pulse animate__slower slow-pulse">
                                            <img src="{{ asset('images/sustainability/CRS_event_PBL/foodwise_impace_report_2024.png') }}" class="csr-image" alt="csr_event_pbl_1">
                                        </div>
                                </div>
                            </div>
                            {{-- <div class="csrSlide animate__animated animate__fadeIn animate__slower 3s">
                                <div class="slide-content">
                                        <div class="image-container animate__animated animate__pulse animate__slower slow-pulse">
                                            <img src="{{ asset('images/sustainability/CRS_event_PBL/2.png') }}" class="csr-image" alt="csr_event_pbl_2">
                                        </div>
                                </div>
                            </div>
                            <div class="csrSlide animate__animated animate__fadeIn animate__slower 3s">
                                <div class="slide-content">
                                        <div class="image-container animate__animated animate__pulse animate__slower slow-pulse">
                                            <img src="{{ asset('images/sustainability/CRS_event_PBL/3.png') }}" class="csr-image" alt="csr_event_pbl_3">
                                        </div>
                                </div>
                            </div>
                            <div class="csrSlide animate__animated animate__fadeIn animate__slower 3s">
                                <div class="slide-content">
                                        <div class="image-container animate__animated animate__pulse animate__slower slow-pulse">
                                            <img src="{{ asset('images/sustainability/CRS_event_PBL/4.png') }}" class="csr-image" alt="csr_event_pbl_4">
                                        </div>
                                </div>
                            </div>
                            <div class="csrSlide animate__animated animate__fadeIn animate__slower 3s">
                                <div class="slide-content">
                                        <div class="image-container animate__animated animate__pulse animate__slower slow-pulse">
                                            <img src="{{ asset('images/sustainability/CRS_event_PBL/5.png') }}" class="csr-image" alt="csr_event_pbl_5">
                                        </div>
                                </div>
                            </div>
                            <div class="csrSlide animate__animated animate__fadeIn animate__slower 3s">
                                <div class="slide-content">
                                        <div class="image-container animate__animated animate__pulse animate__slower slow-pulse">
                                            <img src="{{ asset('images/sustainability/CRS_event_PBL/6.png') }}" class="csr-image" alt="csr_event_pbl_6">
                                        </div>
                                </div>
                            </div>
                            <div class="csrSlide active animate__animated animate__fadeIn animate__slower 3s">
                                <div class="slide-content">
                                        <div class="image-container animate__animated animate__pulse animate__slower slow-pulse">
                                            <img src="{{ asset('images/sustainability/CRS_event_PBL/7.png')  }}" class="csr-image" alt="csr_event_pbl_7">
                                        </div>
                                </div>
                            </div>
                            <div class="csrSlide animate__animated animate__fadeIn animate__slower 3s">
                                <div class="slide-content">
                                        <div class="image-container animate__animated animate__pulse animate__slower slow-pulse">
                                            <img src="{{ asset('images/sustainability/CRS_event_PBL/8.png') }}" class="csr-image" alt="csr_event_pbl_8">
                                        </div>
                                </div>
                            </div> --}}
                            <!-- Add more slides as needed -->
                        </div>

                        <div class="csr-indicators mx-auto" style="left:0;">
                            <span class="csr-indicator active" onclick="currentCrsSlide(0)"></span>
                            {{-- <span class="csr-indicator" onclick="currentCrsSlide(1)"></span>
                            <span class="csr-indicator" onclick="currentCrsSlide(2)"></span>
                            <span class="csr-indicator" onclick="currentCrsSlide(3)"></span>
                            <span class="csr-indicator" onclick="currentCrsSlide(4)"></span>
                            <span class="csr-indicator" onclick="currentCrsSlide(5)"></span>
                            <span class="csr-indicator" onclick="currentCrsSlide(6)"></span>
                            <span class="csr-indicator" onclick="currentCrsSlide(7)"></span> --}}
                            <!-- Add more indicators as needed -->
                        </div>
                    </div>
                </div>
                {{-- <div class="">
                    <img class="csr-info-box" src="{{ asset('images/csr-image.png') }}">
                </div> --}}
            </div>
        </div>

    </div>


@stop
