@extends('layouts.app')

@section('content')
<div class="page-blue">
    <div class="container my-5">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-5">
                <div class="card shadow-lg border-0" style="border-radius: 15px;">
                    <div class="card-body p-5">
                        <div class="text-center mb-4">
                            <div class="mb-3">
                                <i class="fas fa-lock" style="font-size: 3rem; color: #08BABB;"></i>
                            </div>
                            <h3 class="card-title mb-2" style="color: #0A1F2E;">Protected Page</h3>
                            <p class="text-muted mb-0">{{ $pageSetting->page_name }}</p>
                        </div>

                        <form method="POST" action="{{ route('page.password.verify', $pageSetting->id) }}">
                            @csrf
                            
                            <div class="mb-4">
                                <label for="password" class="form-label" style="color: #0A1F2E; font-weight: 600;">
                                    Enter Password
                                </label>
                                <input 
                                    type="password" 
                                    class="form-control @error('password') is-invalid @enderror" 
                                    id="password" 
                                    name="password" 
                                    placeholder="Enter page password"
                                    required 
                                    autofocus
                                    style="padding: 12px; border-radius: 8px; border: 2px solid #e0e0e0;"
                                >
                                @error('password')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <button 
                                type="submit" 
                                class="btn w-100 text-white"
                                style="background-color: #08BABB; padding: 12px; border-radius: 8px; font-weight: 600; transition: all 0.3s;"
                                onmouseover="this.style.backgroundColor='#0A1F2E'"
                                onmouseout="this.style.backgroundColor='#08BABB'"
                            >
                                <i class="fas fa-unlock me-2"></i>Access Page
                            </button>
                        </form>

                        <div class="text-center mt-4">
                            <small class="text-muted">
                                <i class="fas fa-info-circle me-1"></i>
                                This page is password protected
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .page-blue {
        background: linear-gradient(135deg, #f0f4f7 0%, #ffffff 100%);
        min-height: 80vh;
        padding: 2rem 0;
    }
    
    .card {
        transition: transform 0.3s ease;
    }
    
    .card:hover {
        transform: translateY(-5px);
    }
    
    .form-control:focus {
        border-color: #08BABB;
        box-shadow: 0 0 0 0.2rem rgba(8, 186, 187, 0.25);
    }
</style>
@endsection

