@extends('layouts.report')

@section('title', 'Phoenix Beverages Group - Integrated Report '. $year)

@section('content')
<!-- Home Section -->
<div id="home" class="page-blue ireport">
        <div class="row">
            <div class="col-lg-6 col-md-12">
                <div class="mx-auto justify-content-center align-items-center hero-content-desktop"
                    style="padding:120px 0px 0px 150px; width:80%;">
                    <h3 class="fw-bold">Integrated Report <br> {{ $year }}</h3>
                    <p class="smaller-text">This Integrated Report provides information about the strategy, activities
                        and performance of
                        Phoenix Beverages Limited (PhoenixBev or the Group) for the twelve months from 1 July 2023 to 30
                        June {{ $year }}.
                        <br></br>
                        It is structured around the matters most material to the Group's ability to create value in the
                        short-,
                        medium- and longterm.
                        The activities of our operations in Mauritius and Réunion Island are included in the reporting
                        boundary..
                    </p>
                    <div class="cta">
                        <a href="{{ asset('Reports/PhoenixBev/pbl_annual_reports/2024/PBL_IAR_2024_V1.pdf') }}"
                           download="PBL_IAR_2024_V1.pdf" target="_blank">
                        <button class="button pbg-button pbg-shadow-dash">Download Full PDF</button>
                        {{-- <a href="@pdfViewerUrl(asset('Reports/PhoenixBev/pbl_annual_reports/2024/PBL_IAR_2024_V1.pdf'), 'PBL Integrated Annual Report 2024', route('integratedReport', $year))" >
                        <button class="button pbg-button pbg-shadow-dash">View Full PDF</button> --}}
                        </a>
                    </a>
                </div>
                </div>

                <!-- Mobile Hero Content -->
                <div class="hero-content-mobile d-lg-none">
                    <div class="container">
                        <div class="text-center">
                            <h3 class="fw-bold mb-3">Integrated Report <br> {{ $year }}</h3>
                            <p class="smaller-text mb-4">This Integrated Report provides information about the strategy, activities
                                and performance of Phoenix Beverages Limited (PhoenixBev or the Group) for the twelve months from 1 July 2023 to 30
                                June {{ $year }}. It is structured around the matters most material to the Group's ability to create value in the
                                short-, medium- and longterm. The activities of our operations in Mauritius and Réunion Island are included in the reporting
                                boundary.</p>
                            <div class="cta">
                                <a href="@pdfViewerUrl(asset('Reports/PhoenixBev/pbl_annual_reports/2024/PBL_IAR_2024_V1.pdf'), 'PBL Integrated Annual Report 2024', route('integratedReport', $year))" >
                                <button class="button pbg-button pbg-shadow-dash">View Full PDF</button>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-md-12">
                <img src="{{ asset('images/investor-relations/reports/annual-report-2024.png') }}" alt="integrated report"
                    class="responsive-image" />
            </div>
        </div>
    </div>

    <div class="ir-section">
        <div class="container w-75 mx-auto">
        <h3 id="finance-at-a-glance" class="py-5 text-center" data-aos="fade-down" data-aos-duration="500" data-aos-easing="linear">Financial Performance</h3>
            <div class="row pb-6 text-center financial-performance-grid">
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="50" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Team Member</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/fluent_people-team-16-regular.png') }}" alt="team" />
                                </div>
                                <div class="">
                                    <span class="fs-3">+</span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="1750"
                                        data-speed="10000">1750</span>
                                    <span class="green-caret">
                                        <img src="{{ asset('icons/Vector_7.png') }}" alt="caret-up"> 2.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="100" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Revenue ({{ $year }})</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/clarity_container-volume-line.png') }}"
                                        alt="container" />
                                </div>
                                <div class="">
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="2.44"
                                        data-speed="10000">2.44</span><span class="fs-3">M HL</span>
                                    <span class="red-caret">
                                        <img src="{{ asset('icons/Vector_6.png') }}" alt="caret-down"> 1.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="150" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Turnover </h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/ph_coin.png') }}" alt="ph_coin" />
                                </div>
                                <div class="">
                                    <span class="fs-4">MUR </span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="10609"
                                        data-speed="10000">10 609</span> <span class="fs-4">M</span>
                                    <span class="red-caret">
                                        <img src="{{ asset('icons/Vector_6.png') }}" alt="caret-down"> 0.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="200" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Operating Profit</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/fluent_money-20-regular.png') }}" alt="money" />
                                </div>
                                <div class="">
                                    <span class="fs-4">MUR </span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="809"
                                        data-speed="10000">809</span>
                                    <span class="fs-4">M </span>
                                    <span class="green-caret">
                                        <img src="{{ asset('icons/Vector_7.png') }}" alt="caret-up"> 10%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="250" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Net Profit after Tax</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/fluent_coin-stack-24-regular.png') }}"
                                        alt="coin_stack" />
                                </div>
                                <div class="">
                                    <span class="fs-4">MUR</span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="732"
                                        data-speed="10000">732</span> <span class="fs-4">M</span>
                                    <span class="green-caret">
                                        <img src="{{ asset('icons/Vector_7.png') }}" alt="caret-up"> 4%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="300" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Market Capitalization</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/heroicons_chart-pie.png') }}"
                                        alt="heroicons_chart-pie" />
                                </div>
                                <div class="">
                                    <span class="fs-4">MUR</span>
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="8717"
                                        data-speed="10000">8717 </span> <span class="fs-4">M</span>
                                    <span class="red-caret">
                                        <img src="{{ asset('icons/Vector_6.png') }}" alt="caret-down">4%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12" data-aos="fade-down" data-aos-duration="350" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Revenue ({{ $year }})</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/clarity_container-volume-line.png') }}"
                                        alt="container" />
                                </div>
                                <div class="">
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="2.44"
                                        data-speed="10000">2.44 </span>
                                    <span class="fs-4">M HL </span>
                                    <span class="red-caret">
                                        <img src="{{ asset('icons/Vector_6.png') }}" alt="caret-down"> 1.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="400" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Revenue ({{ $year }})</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/clarity_container-volume-line.png') }}"
                                        alt="container" />
                                </div>
                                <div class="">
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="2.44"
                                        data-speed="10000">244 </span><span class="fs-4">M HL </span>
                                    <span class="red-caret">
                                        <img src="{{ asset('icons/Vector_6.png') }}" alt="caret-down"> 1.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4" data-aos="fade-down" data-aos-duration="500" data-aos-easing="linear">
                    <div class="card ir-card">
                        <div class="card-body">
                            <h5 class="card-title">Revenue ({{ $year }})</h5>
                            <div class="card-text">
                                <div class="py-3">
                                    <img src="{{ asset('icons/clarity_container-volume-line.png') }}"
                                        alt="container" />
                                </div>
                                <div class="">
                                    <span class="fs-4 pbgCountUp" style="margin-right: 7px;" data-to="2.44"
                                        data-speed="10000">2.44 </span>
                                    <span class="fs-4">M HL </span>
                                    <span class="red-caret">
                                        <img src="{{ asset('icons/Vector_6.png') }}" alt="caret-down"> 1.5%
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
            </div>
            </div>
        </div>
    </div>

<div class="ir-section-details py-6" id="remarks">
        <div class="container leadership-container">
            <div class="row leadership-section">
                <div class="col-lg-6 col-md-12 leadership-image-col" data-aos="fade-right" data-aos-duration="500" data-aos-easing="linear">
                    <div class="overview-image bg-image pbg-shadow leadership-image"
                        style="background-image: url({{ asset('images/our-leadership/leader-1.png') }})"
                        class="rounded">
                    </div>
                </div>
                <div class="col-lg-6 col-md-12 leadership-content-col" data-aos="fade-left" data-aos-duration="500" data-aos-easing="linear">
                    <div class="leadership-content">
                        <h3>Chairman's message</h3>
                        <h4>Vision in Action</h4>
                        <p class="smallest-text leadership-text">
                            I would like to extend my heartfelt thanks to my fellow
                            directors for their unwavering support and strategic insight
                            throughout the year. Their guidance has been instrumental in
                            navigating the challenges and seizing the opportunities that
                            have come our way.
                            <br><br>I also wish to express my appreciation to
                            the executives and management team, under the leadership
                            of our CEO, Bernard Theys and our COO/ CFO, Patrick Rivalland,
                            for their exemplary leadership and commitment to delivering
                            on our strategic objectives.<br><br>
                            To our dedicated team, your hard work, resilience and passion
                            are the foundation of our success, and I am truly grateful for
                            your continued contribution. Lastly, I would like to thank
                            our valued stakeholders for their trust, collaboration, and
                            confidence in our vision.
                        </p>
                    </div>
                </div>
            </div>

            <div class="row mt-6 leadership-section">
                <div class="col-lg-6 col-md-12 leadership-content-col order-lg-1 order-2" data-aos="fade-right" data-aos-duration="500" data-aos-easing="linear">
                    <div class="leadership-content">
                        <h3>CEO'S review</h3>
                        <div>
                            <p class="smallest-text leadership-text">
                                Business conditions improved somewhat over the past year, but a number of
                                challenges remained.
                                <br><br>
                                These included a weaker currency and the ongoing shortage
                                of foreign currency to pay international suppliers, supply chain complexity that
                                delayed or disrupted deliveries of vital inputs, fluctuating freight costs, rising
                                energy costs and high interest rates.
                                <br></br>
                                We have successfully implemented strategies to mitigate supply chain disruptions caused by
                                raw material
                                shortages and foreign exchange issues.However, the labour market remains
                                extremely tight, particularly for technical skills, and we continue to explore ways
                                to secure the necessary skills to support production and expansion.
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-12 leadership-image-col order-lg-2 order-1" data-aos="fade-left" data-aos-duration="500" data-aos-easing="linear">
                    <div class="overview-image bg-image pbg-shadow leadership-image"
                        style="background-image: url({{ asset('images/our-leadership/leader-11.png') }})"
                        class="rounded">
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        AOS.init({
            once: true,
            duration: 500
        });

        $(document).ready(function() {
            $('.pbgCountUp').each(function() {
                var $this = $(this);
                var rawValue = $this.attr('data-to');
                var target = parseFloat(rawValue);
                var unit = $this.next('.fs-3').text().trim();

                // Calculate number of decimal places ONLY if the original value has decimals
                var decimalPlaces = 0;
                
                if (rawValue && rawValue.toString().includes('.')) {
                    var parts = rawValue.toString().split('.');
                    if (parts.length > 1) {
                        decimalPlaces = parts[1].length;
                    }
                }

                // Initialize CountUp with proper decimal places
                var countUp = new CountUp($this[0], 0, target, decimalPlaces, 10, {
                    separator: ',',
                    decimal: '.'
                });

                var observer = new IntersectionObserver(function(entries, observer) {
                    entries.forEach(function(entry) {
                        if (entry.isIntersecting) {
                            countUp.start();
                            observer.unobserve(entry.target);
                        }
                    });
                }, {
                    threshold: 0.8
                });

                observer.observe($this[0]);

                // Format final value with proper decimals only if originally had decimals
                countUp.callback = function() {
                    var finalValue = countUp.endVal;
                    
                    // Only format with decimals if the original value had decimals
                    if (decimalPlaces > 0) {
                        finalValue = finalValue.toFixed(decimalPlaces);
                    }

                    $this.text(finalValue + ' ' + unit);
                };
            });
        });
    </script>
@endsection