<?php

use App\Services\NewsService;
use Illuminate\Support\Facades\Route;
use App\Services\StaticContentIndexer;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\SearchController;
use App\Http\Controllers\Api\NewsController;
use App\Http\Controllers\Api\CompanydataController;

Route::get('/', [HomeController::class, 'index'])->name('home');

Route::prefix('api')->group(function () {
    Route::get('/brands', [CompanydataController::class, 'brands'])->name('brand-data-brands-api');
    Route::get('/news', [NewsController::class, 'index'])->name('news-api');
    Route::get('/filter-news', [NewsController::class, 'filterNews'])->name('news.filter');
    Route::get('/stock-data', [CompanydataController::class, 'getStockData']);
    Route::get('/stock-metrics', [CompanydataController::class, 'getStockMetrics']);
    Route::get('/stock-data-period', [CompanydataController::class, 'getStockDataByPeriod']);
    Route::get('/latest-stock-data', [CompanydataController::class, 'getlatestStockData']);
    Route::get('/shareholders-data', [CompanydataController::class, 'getShareholdersData']);
    Route::post('send-email', [CompanydataController::class, 'sendEmail'])->name('send.email')->middleware('throttle.forms');

});

Route::get('/about', [HomeController::class, 'aboutUs'])->name('about-us');
Route::get('/contact', [HomeController::class, 'contactUs'])->name('contact-us');
Route::get('/our-brand', [HomeController::class, 'ourBrand'])->name('our-brand');
Route::get('/news-room', [HomeController::class, 'newsRoom'])->name('news-room');
Route::get('/our-reach', [HomeController::class, 'ourReach'])->name('our-reach');
Route::get('/csr', [HomeController::class, 'csr'])->name('csr');
Route::get('/foot-prints', [HomeController::class, 'footPrints'])->name('foot-prints');
Route::get('/phoenix-earth', [HomeController::class, 'phoenixEarth'])->name('phoenix-earth');
Route::get('/innovation', [HomeController::class, 'innovation'])->name('innovation');
Route::get('/our-culture', [HomeController::class, 'ourCulture'])->name('our-culture');
Route::get('/our-leadership', [HomeController::class, 'ourLeadership'])->name('our-leadership');
Route::get('/corporate-governance', [HomeController::class, 'corporateGovernance'])->name('corporate-governance');
Route::get('/our-heritage', [HomeController::class, 'ourHeritage'])->name('our-heritage');
Route::get('/operations-structure', [HomeController::class, 'operationsStructure'])->name('operations-structure');
Route::get('/virtualtours', [HomeController::class, 'virtualtours'])->name('virtualtours');
Route::get('/holding-companies', [HomeController::class, 'holdingCompanies'])->name('holding-companies');
Route::get('/holding-companies/picl', [HomeController::class, 'holdingCompaniesPicl'])->name('holding-companies-picl');
Route::get('/holding-companies/cicl', [HomeController::class, 'holdingCompaniesCicl'])->name('holding-companies-cicl');
// Route::get('/integrated-report', [HomeController::class, 'integratedReport'])->name('integrated-report');
Route::get('/investor-relations',[HomeController::class, 'investorRelations'])->name('investor-relations');
Route::get('/esg',[HomeController::class, 'esg'])->name('esg');
Route::get('/timeline', [HomeController::class, 'getTimeline'])->name('timeline');
Route::get('/careers', [HomeController::class, 'careers'])->name('careers');
Route::prefix('/news')->group(function(){
    Route::get('/{slug}', [HomeController::class, 'newsDetails'])->name('news.details');
});

// Generic PDF Viewer Route
Route::get('/pdf-viewer', [HomeController::class, 'pdfViewer'])->name('pdf.viewer');



Route::prefix('/operations-structure')->group(function(){
    Route::get('phoenix-bev', [HomeController::class, 'phoenixBev'])->name('phoenix-bev');
    Route::get('edena', [HomeController::class, 'edena'])->name('edena');
    Route::get('seybrew', [HomeController::class, 'seybrew'])->name('seybrew');
});


Route::prefix('/reports')->group(function(){
    Route::get('annual', [HomeController::class, 'annualReport'])->name('annual.report');
    // Route::get('integrated-reports', [HomeController::class, 'integratedReportResult'])->name('integrated.report');
    Route::get('piclHoldingsReport', [HomeController::class, 'piclHoldingsReport'])->name('piclholding.report');
    Route::get('pblarchiveReport', [HomeController::class, 'pblarchiveReport'])->name('pblarchive.report');
    Route::get('ciclHoldingsReport', [HomeController::class, 'ciclHoldingsReport'])->name('ciclholding.report');
});

//shareholders
Route::get('/pbl-integrated-report/{year?}', [HomeController::class, 'pbgIntegratedReport'])->name('integratedReport');
Route::get('/picl-integrated-report/{year?}', [HomeController::class, 'piclAnnualReport'])->name('picl-annual-report');
Route::get('/cicl-integrated-report/{year?}', [HomeController::class, 'ciclAnnualReport'])->name('cicl-annual-report');

// Page password protection routes
Route::get('/page-password', [HomeController::class, 'showPasswordEntry'])->name('page.password.entry');
Route::post('/page-password', [HomeController::class, 'verifyPassword'])->name('page.password.verify');

Route::get('/shareholders', [HomeController::class, 'shareholders'])->name('shareholders');



Route::get('/campaign-alcohol',[HomeController::class, 'alcoholicDrink'])->name('alcoholic-drink');
Route::get('/campaign-non-alcohol',[HomeController::class, 'nonAlcoholicDrink'])->name('non-alcoholic-drink');

Route::get('/privacy', [HomeController::class, 'privacy'])->name('privacy');
Route::get('/cookies', [HomeController::class, 'cookie'])->name('cookies');
Route::get('/terms_conditions', [HomeController::class, 'terms_conditions'])->name('terms_conditions');

// Search route
Route::get('/search', [SearchController::class, 'search'])->name('search');

Route::get('static', [StaticContentIndexer::class, 'index'])->name('static.index');

// SEO Routes
Route::get('/sitemap.xml', function() {
    $sitemapService = new \App\Services\SitemapService();
    $sitemapService->addStaticPages()->addDynamicPages();
    return response($sitemapService->generate(), 200, ['Content-Type' => 'application/xml']);
})->name('sitemap.xml');

Route::get('/robots.txt', function() {
    $sitemapService = new \App\Services\SitemapService();
    return response($sitemapService->generateRobotsTxt(), 200, ['Content-Type' => 'text/plain']);
})->name('robots.txt');

Route::post('/careers', [App\Http\Controllers\HomeController::class, 'submitCareers'])->name('submit.careers')->middleware('throttle.forms');

// Spam monitoring routes (protected by admin middleware)
Route::prefix('admin')->middleware(['auth'])->group(function () {
    Route::get('/spam-monitoring', [App\Http\Controllers\SpamMonitoringController::class, 'index'])->name('admin.spam-monitoring');
    Route::get('/spam-stats', [App\Http\Controllers\SpamMonitoringController::class, 'getStats'])->name('admin.spam-stats');
    Route::post('/spam/block-ip', [App\Http\Controllers\SpamMonitoringController::class, 'blockIp'])->name('admin.spam.block-ip');
    Route::post('/spam/unblock-ip', [App\Http\Controllers\SpamMonitoringController::class, 'unblockIp'])->name('admin.spam.unblock-ip');
    Route::post('/spam/clear-old', [App\Http\Controllers\SpamMonitoringController::class, 'clearOldAttempts'])->name('admin.spam.clear-old');
});
Route::get('general-campaign', [App\Http\Controllers\HomeController::class, 'generalCampaign'])->name('general-campaign');
Route::get('acquisition', [App\Http\Controllers\HomeController::class, 'acquisition'])->name('acquisition');

Route::prefix('/virtualtours')->group(function(){
    Route::get('eng-virtualtours', [HomeController::class, 'engVirtualtours'])->name('eng-virtualtours');
    Route::get('frn-virtualtours', [HomeController::class, 'frnVirtualtours'])->name('frn-virtualtours');
});



