<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($seo['title'] ?? 'PDF Viewer - Phoenix Beverages Group'); ?></title>
    <meta name="description" content="<?php echo e($seo['description'] ?? 'Interactive PDF viewer for Phoenix Beverages Group documents'); ?>">
    <meta name="keywords" content="<?php echo e($seo['keywords'] ?? 'Phoenix Beverages, PDF viewer, interactive reader'); ?>">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="article">
    <meta property="og:url" content="<?php echo e($seo['url'] ?? request()->url()); ?>">
    <meta property="og:title" content="<?php echo e($seo['title'] ?? 'PDF Viewer - Phoenix Beverages Group'); ?>">
    <meta property="og:description" content="<?php echo e($seo['description'] ?? 'Interactive PDF viewer for Phoenix Beverages Group documents'); ?>">
    <meta property="og:image" content="<?php echo e($seo['image'] ?? asset('images/logo.png')); ?>">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo e($seo['url'] ?? request()->url()); ?>">
    <meta property="twitter:title" content="<?php echo e($seo['title'] ?? 'PDF Viewer - Phoenix Beverages Group'); ?>">
    <meta property="twitter:description" content="<?php echo e($seo['description'] ?? 'Interactive PDF viewer for Phoenix Beverages Group documents'); ?>">
    <meta property="twitter:image" content="<?php echo e($seo['image'] ?? asset('images/logo.png')); ?>">

    <link rel="canonical" href="<?php echo e($seo['canonical'] ?? request()->url()); ?>">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #ffffff;
            height: 100vh;
            overflow: hidden;
            position: relative;
        }

        .pdf-viewer-container {
            width: 100vw;
            height: 100vh;
            position: relative;
            display: flex;
            flex-direction: column;
            padding-bottom: 35px; /* Space for minimal toolbar */
        }

        .viewer-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            padding: 15px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 20px rgba(8, 186, 187, 0.1);
            z-index: 1000;
            position: relative;
        }

        .viewer-title {
            font-size: 1.2rem;
            font-weight: 600;
            color: #0A1F2E;
            max-width: 60%;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .viewer-controls {
            display: flex;
            gap: 15px;
            align-items: center;
        }

        .back-btn {
            background: #08BABB;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 25px;
            cursor: pointer;
            font-size: 0.9rem;
            font-weight: 500;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 8px;
            text-decoration: none;
        }

        .back-btn:hover {
            background: #0A1F2E;
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(8, 186, 187, 0.3);
        }

        .fullscreen-btn {
            background: #0A1F2E;
            color: white;
            border: none;
            padding: 10px 15px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 0.9rem;
            transition: all 0.3s ease;
        }

        .fullscreen-btn:hover {
            background: #08BABB;
            transform: translateY(-2px);
        }

        .pdf-content {
            flex: 1;
            position: relative;
            overflow: hidden;
            height: calc(100vh - 35px); /* Full height minus minimal toolbar */
        }

        .error-message {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            height: 100%;
            color: #08BABB;
            text-align: center;
            padding: 40px;
        }

        .error-icon {
            font-size: 4rem;
            margin-bottom: 20px;
        }

        .error-title {
            font-size: 1.5rem;
            margin-bottom: 10px;
            font-weight: 600;
        }

        .error-description {
            font-size: 1rem;
            color: #08BABB;
            margin-bottom: 30px;
        }

        .retry-btn {
            background: #08BABB;
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 1rem;
            transition: all 0.3s ease;
        }

        .retry-btn:hover {
            background: #0A1F2E;
            transform: translateY(-2px);
        }

        /* Loading animation */
        .loading-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(5px);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 9999;
        }

        .loading-spinner {
            width: 50px;
            height: 50px;
            border: 4px solid rgba(8, 186, 187, 0.2);
            border-top: 4px solid #08BABB;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Professional Toolbar */
        .pdf-toolbar {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: rgba(255, 255, 255, 0.85);
            backdrop-filter: blur(6px);
            border-top: 1px solid rgba(8, 186, 187, 0.2);
            padding: 4px 15px;
            display: flex;
            justify-content: center;
            align-items: center;
            box-shadow: 0 -1px 6px rgba(8, 186, 187, 0.1);
            z-index: 1000;
            height: 35px;
        }

        .toolbar-section {
            display: flex;
            align-items: center;
            gap: 4px;
        }

        .toolbar-btn {
            background: rgba(8, 186, 187, 0.1);
            border: 1px solid rgba(8, 186, 187, 0.2);
            border-radius: 4px;
            padding: 3px 6px;
            cursor: pointer;
            font-size: 0.8rem;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            min-width: 26px;
            height: 26px;
        }

        .toolbar-btn:hover {
            background: rgba(8, 186, 187, 0.2);
            border-color: rgba(8, 186, 187, 0.4);
            transform: translateY(-0.5px);
            box-shadow: 0 1px 3px rgba(8, 186, 187, 0.2);
        }

        .zoom-level {
            font-size: 0.7rem;
            font-weight: 400;
            color: #08BABB;
            min-width: 35px;
            text-align: center;
        }

        .page-info {
            font-size: 0.7rem;
            font-weight: 500;
            color: #0A1F2E;
            background: rgba(8, 186, 187, 0.1);
            border: 1px solid rgba(8, 186, 187, 0.2);
            border-radius: 4px;
            padding: 2px 8px;
            margin: 0 8px;
            min-width: 60px;
            text-align: center;
        }

        /* Edge Navigation Buttons */
        .edge-nav-btn {
            position: fixed;
            top: 50%;
            transform: translateY(-50%);
            width: 50px;
            height: 50px;
            background: rgba(8, 186, 187, 0.1);
            border: 1px solid rgba(8, 186, 187, 0.2);
            border-radius: 50%;
            color: #0A1F2E;
            font-size: 20px;
            font-weight: bold;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 1000;
            backdrop-filter: blur(8px);
            box-shadow: 0 4px 12px rgba(8, 186, 187, 0.1);
        }

        .edge-nav-btn:hover {
            background: rgba(8, 186, 187, 0.2);
            border-color: rgba(8, 186, 187, 0.4);
            transform: translateY(-50%) scale(1.05);
            box-shadow: 0 6px 16px rgba(8, 186, 187, 0.2);
        }

        .edge-nav-btn:disabled {
            opacity: 0.3;
            cursor: not-allowed;
            transform: translateY(-50%);
        }

        .edge-nav-btn:disabled:hover {
            background: rgba(8, 186, 187, 0.1);
            transform: translateY(-50%);
            box-shadow: 0 4px 12px rgba(8, 186, 187, 0.1);
        }

        .edge-nav-left {
            left: 10px;
        }

        .edge-nav-right {
            right: 10px;
        }

        /* Responsive design */
        @media (max-width: 768px) {
            .viewer-header {
                padding: 10px 15px;
            }
            
            .viewer-title {
                font-size: 1rem;
                max-width: 50%;
            }
            
            .viewer-controls {
                gap: 10px;
            }
            
            .fullscreen-btn {
                padding: 8px 15px;
                font-size: 0.8rem;
            }

            .pdf-toolbar {
                padding: 6px 12px;
                flex-wrap: wrap;
                gap: 6px;
                height: 45px;
            }

            .toolbar-section {
                gap: 4px;
            }

            .toolbar-btn {
                padding: 4px 6px;
                min-width: 28px;
                height: 28px;
                font-size: 0.8rem;
            }

            .zoom-level {
                font-size: 0.7rem;
                min-width: 35px;
            }

            .edge-nav-btn {
                width: 40px;
                height: 40px;
                font-size: 16px;
            }

            .edge-nav-left {
                left: 5px;
            }

            .edge-nav-right {
                right: 5px;
            }
        }

        /* Page loading indicator */
        .page-loading-indicator {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background: rgba(10, 31, 46, 0.9);
            color: white;
            padding: 12px 20px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 14px;
            font-weight: 500;
            z-index: 2000;
            backdrop-filter: blur(8px);
            box-shadow: 0 4px 20px rgba(8, 186, 187, 0.2);
        }

        .page-loading-indicator .loading-spinner {
            width: 16px;
            height: 16px;
            border: 2px solid rgba(8, 186, 187, 0.3);
            border-top: 2px solid #08BABB;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }
    </style>
</head>
<body>
    <div class="pdf-viewer-container">
        <div class="pdf-content">
            <?php if(isset($error)): ?>
                <div class="error-message">
                    <div class="error-icon">📄</div>
                    <div class="error-title">Unable to Load PDF</div>
                    <div class="error-description"><?php echo e($error); ?></div>
                    <button class="retry-btn" onclick="window.location.reload()">
                        Try Again
                    </button>
                </div>
            <?php elseif(isset($pdfUrl)): ?>
                <div id="pdf-viewer-container"></div>
            <?php else: ?>
                <div class="error-message">
                    <div class="error-icon">📄</div>
                    <div class="error-title">No PDF Available</div>
                    <div class="error-description">No PDF URL was provided.</div>
                    <a href="<?php echo e($backUrl ?? '/'); ?>" class="retry-btn" style="text-decoration: none; display: inline-block;">
                        Go Back
                    </a>
                </div>
            <?php endif; ?>
        </div>

        <!-- Professional Toolbar -->
        <div class="pdf-toolbar">
            <div class="toolbar-section">
                <button class="toolbar-btn" onclick="zoomOut()" title="Zoom Out">
                    <span>🔍-</span>
                </button>
                <span class="zoom-level" id="zoom-level">100%</span>
                <button class="toolbar-btn" onclick="zoomIn()" title="Zoom In">
                    <span>🔍+</span>
                </button>
                <button class="toolbar-btn" onclick="fitToWidth()" title="Fit to Width">
                    <span>📏</span>
                </button>
                <button class="toolbar-btn" onclick="fitToPage()" title="Fit to Page">
                    <span>📄</span>
                </button>
                <span class="page-info" id="page-info">Page 1 of 1</span>
                <button class="toolbar-btn" onclick="downloadPDF()" title="Download PDF">
                    <span>⬇️</span>
                </button>
                <button class="toolbar-btn" onclick="printPDF()" title="Print PDF">
                    <span>🖨️</span>
                </button>
                <button class="toolbar-btn" onclick="toggleFullscreen()" title="Fullscreen">
                    <span id="fullscreen-icon">⛶</span>
                </button>
            </div>
        </div>

        <!-- Edge Navigation Buttons -->
        <button class="edge-nav-btn edge-nav-left" id="prev-btn" onclick="previousPage()" title="Previous Page">‹</button>
        <button class="edge-nav-btn edge-nav-right" id="next-btn" onclick="nextPage()" title="Next Page">›</button>
        
        <!-- Loading indicator for on-demand page loading -->
        <div id="page-loading-indicator" class="page-loading-indicator" style="display: none;">
            <div class="loading-spinner"></div>
            <span>Loading page...</span>
        </div>
    </div>

    <!-- Loading overlay -->
    <div class="loading-overlay" id="loading-overlay">
        <div class="loading-spinner"></div>
    </div>

    <!-- Include PDF.js, PDF Renderer, then the DearFlip Engine -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.min.js"></script>
    <script>
        // Configure PDF.js worker
        pdfjsLib.GlobalWorkerOptions.workerSrc = 'https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.worker.min.js';
    </script>
    <script src="<?php echo e(asset('js/pdf-renderer.js')); ?>"></script>
    <script src="<?php echo e(asset('js/dearflip-engine.js')); ?>"></script>

    <script>
        // Hide loading overlay when page is ready
        window.addEventListener('load', function() {
            setTimeout(() => {
                const overlay = document.getElementById('loading-overlay');
                if (overlay) {
                    overlay.style.opacity = '0';
                    overlay.style.transition = 'opacity 0.5s ease-out';
                    setTimeout(() => {
                        overlay.style.display = 'none';
                    }, 500);
                }
            }, 1000);
        });

        // Fullscreen functionality
        function toggleFullscreen() {
            const container = document.querySelector('.pdf-viewer-container');
            const icon = document.getElementById('fullscreen-icon');
            
            if (!document.fullscreenElement) {
                container.requestFullscreen().then(() => {
                    icon.textContent = '⛶';
                }).catch(err => {
                    console.log('Error attempting to enable fullscreen:', err);
                });
            } else {
                document.exitFullscreen().then(() => {
                    icon.textContent = '⛶';
                }).catch(err => {
                    console.log('Error attempting to exit fullscreen:', err);
                });
            }
        }

        // Initialize PDF viewer when page loads
        document.addEventListener('DOMContentLoaded', function() {
            <?php if(isset($pdfUrl) && !isset($error)): ?>
              
                
                // Create a unique container ID
                const containerId = 'pdf-viewer-' + Date.now();
                const container = document.getElementById('pdf-viewer-container');
                container.id = containerId;
                
                // Wait a bit for all scripts to load
                setTimeout(() => {
                    // Initialize the PDF viewer
                    if (window.DearFlipEngine) {
                        console.log('Creating flipbook...');
                        
                        // Ensure the PDF URL is properly formatted
                        let pdfUrl = '<?php echo e($pdfUrl); ?>';
                        console.log('Original PDF URL:', pdfUrl);
                        
                        // If it's a relative path, make it absolute
                        if (pdfUrl.startsWith('/') || pdfUrl.startsWith('./') || pdfUrl.startsWith('../')) {
                            pdfUrl = window.location.origin + (pdfUrl.startsWith('/') ? pdfUrl : '/' + pdfUrl);
                            console.log('Converted to absolute URL:', pdfUrl);
                        }
                        
                        window.DearFlipEngine.create(containerId, pdfUrl, {
                            height: '100%',
                            width: '100%',
                            showControls: true,
                            showThumbnails: false,
                            showSearch: false,
                            showFullscreen: false, // We handle fullscreen ourselves
                            showDownload: true,
                            showPrint: true,
                            showShare: false,
                            autoPlay: false,
                            pageMode: 'double',
                            webgl: true,
                            enableAnnotations: true,
                            enableBookmarks: true,
                            enableHighlights: true
                        }).then(() => {
                            // Initialize navigation button states and page info after PDF loads
                            setTimeout(() => {
                                const instanceKeys = Array.from(window.DearFlipEngine.instances.keys());
                                if (instanceKeys.length > 0) {
                                    const containerId = instanceKeys[0];
                                    const container = document.getElementById(containerId);
                                    if (container) {
                                        window.DearFlipEngine.updateButtonStates(container);
                                        updatePageInfo(); // Update page information
                                    }
                                }
                            }, 500);
                        });
                    } else {
                        console.error('DearFlipEngine not loaded');
                        showError('PDF viewer engine not loaded. Please refresh the page.');
                    }
                }, 100);
            <?php endif; ?>
        });

        function showError(message) {
            const container = document.getElementById('pdf-viewer-container');
            container.innerHTML = `
                <div class="error-message">
                    <div class="error-icon">⚠️</div>
                    <div class="error-title">Error Loading PDF</div>
                    <div class="error-description">${message}</div>
                    <button class="retry-btn" onclick="window.location.reload()">
                        Try Again
                    </button>
                </div>
            `;
        }

        // Handle fullscreen change events
        document.addEventListener('fullscreenchange', function() {
            const icon = document.getElementById('fullscreen-icon');
            if (document.fullscreenElement) {
                icon.textContent = '⛶';
            } else {
                icon.textContent = '⛶';
            }
        });

        // Handle escape key to exit fullscreen
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape' && document.fullscreenElement) {
                document.exitFullscreen();
            }
        });

        // Toolbar Functions
        let currentZoom = 100;

        function zoomIn() {
            currentZoom = Math.min(currentZoom + 25, 300);
            updateZoom();
        }

        function zoomOut() {
            currentZoom = Math.max(currentZoom - 25, 100); // Minimum zoom is 100%
            updateZoom();
        }

        function updateZoom() {
            const zoomLevel = document.getElementById('zoom-level');
            if (zoomLevel) {
                zoomLevel.textContent = currentZoom + '%';
            }
            
            // Apply zoom to the flipbook container while preserving existing translate
            const container = document.querySelector('.dearflip-container');
            if (container) {
                // Get existing transform and extract translate values
                const existingTransform = container.style.transform || '';
                const translateMatch = existingTransform.match(/translate\(([^)]+)\)/);
                const translateValue = translateMatch ? translateMatch[1] : '0px, 0px';
                
                // Apply scale and preserve translate
                container.style.transform = `scale(${currentZoom / 100}) translate(${translateValue})`;
                container.style.transformOrigin = 'center center';
            }
        }

        function fitToWidth() {
            currentZoom = 100;
            // Reset drag position when fitting
            const container = document.querySelector('.dearflip-container');
            if (container) {
                container.style.transform = `scale(${currentZoom / 100})`;
            }
            updateZoom();
            console.log('Fit to width');
        }

        function fitToPage() {
            currentZoom = 100;
            // Reset drag position when fitting
            const container = document.querySelector('.dearflip-container');
            if (container) {
                container.style.transform = `scale(${currentZoom / 100})`;
            }
            updateZoom();
            console.log('Fit to page');
        }

        function updatePageInfo() {
            if (window.DearFlipEngine) {
                const instanceKeys = Array.from(window.DearFlipEngine.instances.keys());
                if (instanceKeys.length > 0) {
                    const containerId = instanceKeys[0];
                    const instance = window.DearFlipEngine.instances.get(containerId);
                    if (instance) {
                        const currentPage = instance.currentPage || 1;
                        const totalPages = instance.totalPages || 1;
                        
                        const pageInfoElement = document.getElementById('page-info');
                        if (pageInfoElement) {
                            if (totalPages === 1) {
                                // Single page document
                                pageInfoElement.textContent = `Page 1 of 1`;
                            } else {
                                // Multi-page document - show the range of pages being displayed
                                const leftPage = currentPage - 1;
                                const rightPage = currentPage;
                                pageInfoElement.textContent = `Pages ${leftPage}-${rightPage} of ${totalPages}`;
                            }
                        }
                    }
                }
            }
        }

        function showPageLoadingIndicator() {
            const indicator = document.getElementById('page-loading-indicator');
            if (indicator) {
                indicator.style.display = 'flex';
            }
        }

        function hidePageLoadingIndicator() {
            const indicator = document.getElementById('page-loading-indicator');
            if (indicator) {
                indicator.style.display = 'none';
            }
        }

        function downloadPDF() {
            <?php if(isset($pdfUrl)): ?>
                const link = document.createElement('a');
                link.href = '<?php echo e($pdfUrl); ?>';
                link.download = '<?php echo e($title ?? "document"); ?>.pdf';
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
            <?php endif; ?>
        }

        function printPDF() {
            <?php if(isset($pdfUrl)): ?>
                window.open('<?php echo e($pdfUrl); ?>', '_blank');
            <?php endif; ?>
        }

        // Navigation Functions
        function goBack() {
            <?php if(isset($backUrl)): ?>
                window.location.href = '<?php echo e($backUrl); ?>';
            <?php else: ?>
                window.history.back();
            <?php endif; ?>
        }

        function previousPage() {
            if (window.DearFlipEngine) {
                // Get the actual container ID from the DearFlipEngine instances
                const instanceKeys = Array.from(window.DearFlipEngine.instances.keys());
                if (instanceKeys.length > 0) {
                    const containerId = instanceKeys[0]; // Use the first (and likely only) instance
                    window.DearFlipEngine.previousPage(containerId);
                    // Update page info after navigation
                    setTimeout(updatePageInfo, 100);
                } else {
                    console.error('No DearFlipEngine instances found');
                }
            }
        }

        function nextPage() {
            if (window.DearFlipEngine) {
                // Get the actual container ID from the DearFlipEngine instances
                const instanceKeys = Array.from(window.DearFlipEngine.instances.keys());
                if (instanceKeys.length > 0) {
                    const containerId = instanceKeys[0]; // Use the first (and likely only) instance
                    window.DearFlipEngine.nextPage(containerId);
                    // Update page info after navigation
                    setTimeout(updatePageInfo, 100);
                } else {
                    console.error('No DearFlipEngine instances found');
                }
            }
        }

    </script>
</body>
</html>
<?php /**PATH /home/plrgpimy/public_html/enhanced_pbg/resources/views/pdf-viewer.blade.php ENDPATH**/ ?>